/*
 * Decompiled with CFR 0.152.
 */
package kiwiapollo.cobblemontrainerbattle.pokemon;

import com.cobblemon.mod.common.api.Priority;
import com.cobblemon.mod.common.api.abilities.Abilities;
import com.cobblemon.mod.common.api.moves.Move;
import com.cobblemon.mod.common.api.moves.Moves;
import com.cobblemon.mod.common.api.pokemon.Natures;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.stats.Stats;
import com.cobblemon.mod.common.pokemon.Gender;
import com.cobblemon.mod.common.pokemon.Pokemon;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import kiwiapollo.cobblemontrainerbattle.CobblemonTrainerBattle;
import kiwiapollo.cobblemontrainerbattle.exception.PokemonParseException;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownMoveParser;
import kiwiapollo.cobblemontrainerbattle.pokemon.ShowdownPokemon;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ShowdownPokemonParser {
    public static final int DEFAULT_LEVEL = 50;
    private static final Map<String, Set<String>> FORM_ASPECTS = Map.ofEntries(Map.entry("Normal", Set.of()), Map.entry("Alola", Set.of("alolan")), Map.entry("Alola Bias", Set.of("region-bias-alola")), Map.entry("Galar", Set.of("galarian")), Map.entry("Galar Bias", Set.of("region-bias-galar")), Map.entry("Hisui", Set.of("hisuian")), Map.entry("Hisui Bias", Set.of("region-bias-hisui")), Map.entry("Paldea", Set.of("paldean")), Map.entry("Paldea Bias", Set.of("region-bias-paldea")), Map.entry("Paldea-Aqua", Set.of("paldean-breed-aqua")), Map.entry("Paldea-Blaze", Set.of("paldean-breed-blaze")), Map.entry("Paldea-Combat", Set.of("paldean-breed-combat")), Map.entry("Therian", Set.of("therian")), Map.entry("Zen", Set.of("zen_mode")), Map.entry("Galar-Zen", Set.of("galarian", "zen_mode")));

    public Pokemon toCobblemonPokemon(ShowdownPokemon showdownPokemon) throws PokemonParseException {
        Pokemon pokemon = this.createBasePokemon(showdownPokemon);
        this.setPokemonForm(pokemon, this.getFormName(showdownPokemon.species, showdownPokemon.form));
        this.setPokemonShiny(pokemon, showdownPokemon.shiny);
        this.setPokemonStats((arg_0, arg_1) -> ((Pokemon)pokemon).setEV(arg_0, arg_1), showdownPokemon.evs);
        this.setPokemonStats((arg_0, arg_1) -> ((Pokemon)pokemon).setIV(arg_0, arg_1), showdownPokemon.ivs);
        this.setPokemonGender(pokemon, showdownPokemon.gender);
        this.setPokemonMoveSet(pokemon, showdownPokemon.moves);
        this.setPokemonHeldItem(pokemon, showdownPokemon.item);
        this.setPokemonAbility(pokemon, showdownPokemon.ability);
        this.setPokemonLevel(pokemon, showdownPokemon.level);
        this.setPokemonNature(pokemon, showdownPokemon.nature);
        return pokemon;
    }

    private Pokemon createBasePokemon(ShowdownPokemon showdownPokemon) throws PokemonParseException {
        try {
            class_2960 identifier = ShowdownPokemonParser.toSpeciesResourceIdentifier(showdownPokemon.species);
            return PokemonSpecies.INSTANCE.getByIdentifier(identifier).create(50);
        }
        catch (ClassCastException | NullPointerException e) {
            throw new PokemonParseException();
        }
    }

    private void setPokemonForm(Pokemon pokemon, String form) {
        pokemon.getSpecies().getForms().stream().filter(formData -> formData.getName().equals(form)).findFirst().ifPresent(formData -> pokemon.setForcedAspects(new HashSet(formData.getAspects())));
    }

    private String getFormName(String species, String form) {
        return FORM_ASPECTS.keySet().stream().filter(species::contains).findFirst().orElse(form);
    }

    private void setPokemonShiny(Pokemon pokemon, boolean shiny) {
        pokemon.setShiny(shiny);
    }

    protected void setPokemonLevel(Pokemon pokemon, int level) {
        pokemon.setLevel(level);
    }

    private void setPokemonAbility(Pokemon pokemon, String ability) {
        try {
            pokemon.updateAbility(Abilities.INSTANCE.getOrException(ability.replace(" ", "").toLowerCase()).create(false, Priority.LOW));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private void setPokemonStats(BiConsumer<Stats, Integer> consumer, Map<String, Integer> stats) {
        if (Objects.isNull(stats)) {
            return;
        }
        if (stats.containsKey("hp")) {
            consumer.accept(Stats.HP, stats.get("hp"));
        }
        if (stats.containsKey("atk")) {
            consumer.accept(Stats.ATTACK, stats.get("atk"));
        }
        if (stats.containsKey("def")) {
            consumer.accept(Stats.DEFENCE, stats.get("def"));
        }
        if (stats.containsKey("spa")) {
            consumer.accept(Stats.SPECIAL_ATTACK, stats.get("spa"));
        }
        if (stats.containsKey("spd")) {
            consumer.accept(Stats.SPECIAL_DEFENCE, stats.get("spd"));
        }
        if (stats.containsKey("spe")) {
            consumer.accept(Stats.SPEED, stats.get("spe"));
        }
    }

    private void setPokemonNature(Pokemon pokemon, String nature) {
        try {
            Objects.requireNonNull(nature);
            boolean isContainNamespace = nature.contains(":");
            if (isContainNamespace) {
                pokemon.setNature(Objects.requireNonNull(Natures.INSTANCE.getNature(class_2960.method_60654((String)nature.toLowerCase()))));
            } else {
                class_2960 identifier = class_2960.method_60655((String)"cobblemon", (String)nature.toLowerCase());
                pokemon.setNature(Objects.requireNonNull(Natures.INSTANCE.getNature(identifier)));
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private void setPokemonGender(Pokemon pokemon, String gender) {
        try {
            pokemon.setGender(this.toGender(gender));
        }
        catch (IllegalArgumentException | NullPointerException runtimeException) {
            // empty catch block
        }
    }

    private Gender toGender(String gender) throws IllegalArgumentException {
        return switch (gender) {
            case "M" -> Gender.MALE;
            case "F" -> Gender.FEMALE;
            case "N" -> Gender.GENDERLESS;
            default -> throw new IllegalArgumentException();
        };
    }

    private void setPokemonHeldItem(Pokemon pokemon, String item) {
        try {
            pokemon.swapHeldItem(this.toHeldItem(item), false);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private class_1799 toHeldItem(String item) {
        if (item.contains(":")) {
            return new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_12829((String)item)));
        }
        String path = item;
        path = path.toLowerCase();
        path = ShowdownPokemonParser.removeNonLowerCaseAlphanumeric(path);
        return new class_1799((class_1935)class_7923.field_41178.method_10223(class_2960.method_60655((String)"cobblemon", (String)path)));
    }

    private void setPokemonMoveSet(Pokemon pokemon, List<String> moveSet) {
        if (this.isUseDefaultMoveSet(moveSet)) {
            return;
        }
        pokemon.getMoveSet().clear();
        for (String moveName : moveSet) {
            try {
                Move move = Moves.INSTANCE.getByName(new ShowdownMoveParser().toCobblemonMove(moveName)).create();
                pokemon.getMoveSet().add(move);
            }
            catch (NullPointerException e) {
                List<String> ignore = List.of("None");
                if (ignore.contains(moveName)) {
                    return;
                }
                CobblemonTrainerBattle.LOGGER.error("Move not found: {}", (Object)moveName);
            }
        }
    }

    private boolean isUseDefaultMoveSet(List<String> moveSet) {
        return moveSet == null || moveSet.isEmpty();
    }

    public static class_2960 toSpeciesResourceIdentifier(String species) {
        if (species.contains(":")) {
            return class_2960.method_12829((String)species);
        }
        return class_2960.method_60655((String)"cobblemon", (String)ShowdownPokemonParser.toSpeciesResourcePath(species));
    }

    private static String toSpeciesResourcePath(String species) {
        String path = species;
        path = ShowdownPokemonParser.removeFormName(path);
        path = path.toLowerCase();
        path = ShowdownPokemonParser.removeNonLowerCaseAlphanumeric(path);
        return path;
    }

    private static String removeNonLowerCaseAlphanumeric(String species) {
        return species.replaceAll("[^a-z0-9]", "");
    }

    private static String removeFormName(String species) {
        String s = species;
        for (String form : FORM_ASPECTS.keySet()) {
            s = s.replaceAll(form, "");
        }
        return s;
    }
}

